#ifndef __vector_h__
#define __vector_h__

#include <string.h>
#include <stdlib.h>
#include <iostream.h>

#define MIN(A,B)		(min(A,B))
#define MAX(A,B)		(max(A,B))

#define ERROR_UNDEFNAME 					"noname"
#define ERROR_UNDEFREASON     			"no reason"
#define ERROR_INVALID_CONSTRUCT_INDEX  "Invalid construct index value."
#define ERROR_INVALID_INDEX  				"Invalid index."
#define ERROR_INVALID_IO					"Invalid I/O."
#define ERROR_INVALID_SIZE_SUM			"Invalid size for operator +."
#define ERROR_INVALID_SIZE_SUB			"Invalid size for operaror -."
#define ERROR_INVALID_SIZE_MUL			"Invalid size for operator *."
#define ERROR_INVALID_SIZE_DIV			"Invalid size for operaror /."


// -----> Definition de la classe Vector
//
//	David Desmarest juillet 1996
//
// SE :
// Define : DEBUG_VECTOR gnrer des exceptions sur les oprations non valide
//				NO_INDEX_CHECK ne controle plus les indices pour l'operateur [] 
//
class VectorError;

template <class T>
class Vector
 { char 		*Name;
   int		MinIndex, MaxIndex;
 	T			*Values;
   T			MinValue, MaxValue;
   public:
   Vector() { Name = 0; MinIndex = MaxIndex = -1; Values = 0; }
   Vector(const char *name);
   Vector(const char *name, int minIndex, int maxIndex);
   Vector(Vector<T>	&aVector);
   ~Vector();
   T &operator[](int index) throw(VectorError);
   Vector<T> &operator=(Vector<T> &aVector);

	friend Vector<T> operator+(Vector<T> &vectorA, Vector<T> &vectorB);
	friend Vector<T> operator-(Vector<T> &vectorA, Vector<T> &vectorB);
	friend Vector<T> operator*(Vector<T> &vectorA, Vector<T> &vectorB);
	friend Vector<T> operator/(Vector<T> &vectorA, Vector<T> &vectorB);

	friend Vector<T> operator+(Vector<T> &aVector, T &aFloat);
	friend Vector<T> operator-(Vector<T> &aVector, T &aFloat);
	friend Vector<T> operator*(Vector<T> &aVector, T &aFloat);
	friend Vector<T> operator/(Vector<T> &aVector, T &aFloat);

   Vector<T> &operator +=(Vector<T> &aVector);
   Vector<T> &operator -=(Vector<T> &aVector);
   Vector<T> &operator *=(Vector<T> &aVector);
   Vector<T> &operator /=(Vector<T> &aVector);

   Vector<T> &operator +=(T &aValue);
   Vector<T> &operator -=(T &aValue);
   Vector<T> &operator *=(T &aValue);
   Vector<T> &operator /=(T &aValue);

   int operator < (Vector &aVector);

   T min() { return MinValue; }
   T max() { return MaxValue; }

   char *name() { return Name != 0?Name:""; }
	Vector<T> &rename(const char *name);
   Vector<T> &resize(int minIndex, int maxIndex);
   int minIndex() { return MinIndex; }
   int maxIndex() { return MaxIndex; }
   int size() { return MaxIndex -MinIndex + 1; }
   bool inRange(int anIndex) { return MinIndex <= anIndex && anIndex <= MaxIndex; }
	Vector<T> &initMinMax();



   friend istream &operator >>(istream &input, Vector<T> &aVector);
   friend ostream &operator <<(ostream &output, Vector<T> &aVector);
 };

// -----> Dfinitiond de la classe VectorError
//
// SE :
class VectorError
 { char 		*VectorName;
 	char 		*Why;
   public:
	VectorError(const char *vectorName = "",const char *why = "");
   VectorError(VectorError &anError);
	~VectorError();
   char *vectorName() const { return VectorName; }
   char *why() const { return Why; }
 };

/*
  *
  * Dfinition des mthodes template de Vector
  *
*/

// -----> Constructeur
//
// SE :
template <class T>
Vector<T>::Vector(const char *name)
 { Name = 0;
 	rename(name);
   MinIndex = MaxIndex = -1;
   Values = 0;
 }
template <class T>
Vector<T>::Vector(const char *name, int minIndex, int maxIndex)
 { Name = 0;
 	rename(name);
   Values = 0;
   resize(minIndex, maxIndex);
 }
template <class T>
Vector<T>::Vector(Vector<T> &aVector)
 { Name = 0;
 	rename(aVector.Name);
	MinIndex = aVector.MinIndex;
	MaxIndex = aVector.MaxIndex;
   if (aVector.Values)
	 { Values = new T[MaxIndex - MinIndex + 1];
   	for (int i = 0;i <= MaxIndex - MinIndex;i++)
   		Values[i] = aVector.Values[i];
    }
   else
   	Values = 0;
 }
// -----> Destructeur
//
// SE :
template <class T>
Vector<T>::~Vector()
 { if (Name)
		delete [] Name;
	if (Values)
		delete [] Values;
 }
// -----> operator []
//
// SE :
template <class T>
T &Vector<T>::operator[](int anIndex) throw (VectorError)
 {
#ifndef NO_INDEX_CHECK
 if (MinIndex <= anIndex && anIndex <= MaxIndex)
#endif
		return Values[anIndex - MinIndex];
#ifndef NO_INDEX_CHECK
	throw VectorError(name(), ERROR_INVALID_INDEX);
#endif
 }
// -----> operator =
//
// SE :
template <class T>
Vector<T> &Vector<T>::operator=(Vector<T> &aVector)
 { if (Values && size() == aVector.size())
 	 { MinIndex = aVector.MinIndex;
      MaxIndex = aVector.MaxIndex;
		for (int i = 0;i <= MaxIndex - MinIndex;i++)
   		Values[i] = aVector.Values[i];
      return *this;
    }
   if (Values)
    { Values += MinIndex;
		delete [] Values;
    }
   MinIndex = aVector.MinIndex;
	MaxIndex = aVector.MaxIndex;
	if (aVector.Values)
	 {	Values = new T[MaxIndex - MinIndex + 1];
   	for (int i = 0;i <= MaxIndex - MinIndex;i++)
   	Values[i] = aVector.Values[i];
    }
   else
		Values = 0;
   return *this;
 }
// -----> operator +
//
// SE :
template <class T>
Vector<T> operator+(Vector<T> &vectorA, Vector<T> &vectorB)
 {
#ifdef DEBUG_VECTOR
	if (vectorA.minIndex() != vectorB.minIndex() || vectorA.maxIndex() != vectorB.maxIndex())
   	throw VectorError(vectorA.name(), ERROR_INVALID_SIZE_SUM);
   char		*buffer = new char[strlen(vectorA.name()) + strlen(vectorB.name()) + 4];
   strcpy(buffer,"(");
   strcat(buffer,vectorA.name());
   strcat(buffer,"+");
   strcat(buffer,vectorB.name());
   strcat(buffer,")");
   Vector<T>	tmp(buffer,vectorA.minIndex(), vectorA.maxIndex());
   delete [] buffer;
#else
   Vector<T>	tmp;
   tmp.resize(vectorA.minIndex(), vectorA.maxIndex());
#endif

   for (int i = tmp.minIndex();i <= tmp.maxIndex();i++)
   	tmp[i] = vectorA[i] + vectorB[i];
   return tmp;
 }
// -----> operator -
//
// SE :
template <class T>
Vector<T> operator-(Vector<T> &vectorA, Vector<T> &vectorB)
 {
#ifdef DEBUG_VECTOR
	if (vectorA.minIndex() != vectorB.minIndex() || vectorA.maxIndex() != vectorB.maxIndex())
   	throw VectorError(vectorA.name(), ERROR_INVALID_SIZE_SUB);
   char		*buffer = new char[strlen(vectorA.name()) + strlen(vectorB.name()) + 4];
   strcpy(buffer,"(");
   strcat(buffer,vectorA.name());
   strcat(buffer,"-");
   strcat(buffer,vectorB.name());
   strcat(buffer,")");
   Vector<T>	tmp(buffer,vectorA.minIndex(), vectorA.maxIndex());
   delete [] buffer;
#else
   Vector<T>	tmp;
   tmp.resize(vectorA.minIndex(), vectorA.maxIndex());
#endif

   for (int i = tmp.minIndex();i <= tmp.maxIndex();i++)
   	tmp[i] = vectorA[i] - vectorB[i];
   return tmp;
 }
// -----> operator *
//
// SE :
template <class T>
Vector<T> operator*(Vector<T> &vectorA, Vector<T> &vectorB)
 {
#ifdef DEBUG_VECTOR
	if (vectorA.minIndex() != vectorB.minIndex() || vectorA.maxIndex() != vectorB.maxIndex())
   	throw VectorError(vectorA.name(), ERROR_INVALID_SIZE_MUL);
   char		*buffer = new char[strlen(vectorA.name()) + strlen(vectorB.name()) + 4];
   strcpy(buffer,"(");
   strcat(buffer,vectorA.name());
   strcat(buffer,"*");
   strcat(buffer,vectorB.name());
   strcat(buffer,")");
   Vector<T>	tmp(buffer,vectorA.minIndex(), vectorA.maxIndex());
   delete [] buffer;
#else
   Vector<T>	tmp;
   tmp.resize(vectorA.minIndex(), vectorA.maxIndex());
#endif

   for (int i = tmp.minIndex();i <= tmp.maxIndex();i++)
   	tmp[i] = vectorA[i] * vectorB[i];
   return tmp;
 }
// -----> operator /
//
// SE :
template <class T>
Vector<T> operator/(Vector<T> &vectorA, Vector<T> &vectorB)
 {
#ifdef DEBUG_VECTOR
	if (vectorA.minIndex() != vectorB.minIndex() || vectorA.maxIndex() != vectorB.maxIndex())
   	throw VectorError(vectorA.name(), ERROR_INVALID_SIZE_DIV);
   char		*buffer = new char[strlen(vectorA.name()) + strlen(vectorB.name()) + 4];
   strcpy(buffer,"(");
   strcat(buffer,vectorA.name());
   strcat(buffer,"/");
   strcat(buffer,vectorB.name());
   strcat(buffer,")");
   Vector<T>	tmp(buffer,vectorA.minIndex(), vectorA.maxIndex());
   delete [] buffer;
#else
   Vector<T>	tmp;
   tmp.resize(vectorA.minIndex(), vectorA.maxIndex());
#endif

   for (int i = tmp.minIndex();i <= tmp.maxIndex();i++)
   	tmp[i] = vectorA[i] / vectorB[i];
   return tmp;
 }
// -----> operator +
//
// SE :
template <class T>
Vector<T> operator+(Vector<T> &aVector, T &aFloat)
 {
#ifdef DEBUG_VECTOR
   Vector<T>	tmp(aVector);
#else
   Vector<T>	tmp;
	tmp.resize(aVector.minIndex(), aVector.maxIndex());
#endif
 	for (int i = aVector.MinIndex;i <= aVector.MaxIndex;i++)
   	tmp[i] = aVector[i] + aFloat;
   return tmp;
 }
// -----> operator -
//
// SE :
template <class T>
Vector<T> operator-(Vector<T> &aVector, T &aFloat)
 {
#ifdef DEBUG_VECTOR
   Vector<T>	tmp(aVector);
#else
   Vector<T>	tmp;
	tmp.resize(aVector.minIndex(), aVector.maxIndex());
#endif
 	for (int i = aVector.MinIndex;i <= aVector.MaxIndex;i++)
   	tmp[i] = aVector[i] - aFloat;
   return tmp;
 }
// -----> operator *
//
// SE :
template <class T>
Vector<T> operator*(Vector<T> &aVector, T &aFloat)
 {
#ifdef DEBUG_VECTOR
   Vector<T>	tmp(aVector);
#else
   Vector<T>	tmp;
	tmp.resize(aVector.minIndex(), aVector.maxIndex());
#endif

 	for (int i = aVector.MinIndex;i <= aVector.MaxIndex;i++)
   	tmp[i] = aVector[i] * aFloat;
   return tmp;
 }
// -----> operator /
//
// SE :
template <class T>
Vector<T> operator/(Vector<T> &aVector, T &aFloat)
 {
#ifdef DEBUG_VECTOR
   Vector<T>	tmp(aVector);
#else
   Vector<T>	tmp;
	tmp.resize(aVector.minIndex(), aVector.maxIndex());
#endif
 	for (int i = aVector.MinIndex;i <= aVector.MaxIndex;i++)
   	tmp[i] = aVector[i] / aFloat;
   return tmp;
 }
// -----> operator += Vector
//
// SE :
template <class T>
Vector<T> &Vector<T>::operator+=(Vector<T> &vectorB)
 {
#ifdef DEBUG_VECTOR
	if (minIndex() != vectorB.minIndex() || maxIndex() != vectorB.maxIndex())
   	throw VectorError(vectorA.name(), ERROR_INVALID_SIZE_SUM);
#endif

   for (int i = minIndex();i <= maxIndex();i++)
   	operator[](i) += vectorB[i];
   return *this;
 }
// -----> operator -=
//
// SE :
template <class T>
Vector<T> &Vector<T>::operator-=(Vector<T> &vectorB)
 {
#ifdef DEBUG_VECTOR
	if (minIndex() != vectorB.minIndex() || maxIndex() != vectorB.maxIndex())
   	throw VectorError(vectorA.name(), ERROR_INVALID_SIZE_SUM);
#endif

   for (int i = minIndex();i <= maxIndex();i++)
   	operator[](i) -= vectorB[i];
   return *this;
 }
// -----> operator *= Vector
//
// SE :
template <class T>
Vector<T> &Vector<T>::operator*=(Vector<T> &vectorB)
 {
#ifdef DEBUG_VECTOR
	if (minIndex() != vectorB.minIndex() || maxIndex() != vectorB.maxIndex())
   	throw VectorError(vectorA.name(), ERROR_INVALID_SIZE_MUL);
#endif

   for (int i = minIndex();i <= maxIndex();i++)
   	operator[](i) *= vectorB[i];
   return *this;
 }
// -----> operator /= Vector
//
// SE :
template <class T>
Vector<T> &Vector<T>::operator/=(Vector<T> &vectorB)
 {
#ifdef DEBUG_VECTOR
	if (minIndex() != vectorB.minIndex() || maxIndex() != vectorB.maxIndex())
   	throw VectorError(vectorA.name(), ERROR_INVALID_SIZE_DIV);
#endif

   for (int i = minIndex();i <= maxIndex();i++)
   	operator[](i) /= vectorB[i];
   return *this;
 }

// -----> operator +=
//
// SE :
template <class T>
Vector<T> &Vector<T>::operator+=(T &aFloat)
 {	for (int i = minIndex();i <= maxIndex();i++)
   	operator[](i) += aFloat;
   return *this;
 }
// -----> operator -=
//
// SE :
template <class T>
Vector<T> &Vector<T>::operator-=(T &aFloat)
 {	for (int i = minIndex();i <= maxIndex();i++)
   	operator[](i) -= aFloat;
   return *this;
 }
// -----> operator *=
//
// SE :
template <class T>
Vector<T> &Vector<T>::operator*=(T &aFloat)
 {	for (int i = minIndex();i <= maxIndex();i++)
   	operator[](i) *= aFloat;
   return *this;
 }
// -----> operator /=
//
// SE :
template <class T>
Vector<T> &Vector<T>::operator/=(T &aFloat)
 {	for (int i = minIndex();i <= maxIndex();i++)
   	operator[](i) /= aFloat;
   return *this;
 }


// -----> rename
//
// SE :
template <class T>
Vector<T> &Vector<T>::rename(const char *name)
 { if (Name)
 		delete [] Name;
   if (name)
 	 {	Name = new char[strlen(name) + 1];
      strcpy(Name,name);
    }
   else
   	Name = 0;
   return *this;
 }
// -----> resize
//
// SE :
template <class T>
Vector<T> &Vector<T>::resize(int minIndex, int maxIndex)
 { if (MinIndex == minIndex && maxIndex == MaxIndex)
 		return *this;
   if (Values)
 		delete [] Values;
	if (maxIndex - minIndex + 1<= 0)
   	throw VectorError(Name, ERROR_INVALID_CONSTRUCT_INDEX);
   MinIndex = minIndex;
   MaxIndex = maxIndex;
	Values = new T[maxIndex - minIndex + 1];
   return *this;
 }
// -----> operator <
//
// SE :
template <class T>
int Vector<T>::operator < (Vector &aVector)
 { T		sum1(Values[0]),sum2(aVector.Values[0]);
   for (int i = 1;i <= MaxIndex - MinIndex;i++)
   	sum1 += Values[i];

   for (int i = 1;i <= aVector.MaxIndex - aVector.MinIndex;i++)
   	sum2 += aVector.Values[i];
   return sum1 < sum2;
 }


// -----> initMinMax
//
// SE : initialise le MinValue et le MaxValues en fonction de Value
template <class T>
Vector<T> &Vector<T>::initMinMax()
 { if (Values)
    { MinValue = Values[0];
 		MaxValue = Values[0];
    }

   for (int i = 1;i <= MaxIndex - MinIndex;i++)
    { if (Values[i] < MinValue)
    		MinValue = Values[i];
		if (MaxValue < Values[i])
    		MaxValue = Values[i];
    }
   return *this;
 }
// -----> operator >>
//
// SE :
template <class T>
istream &operator >>(istream &input, Vector<T> &aVector)
 { int minIndex, maxIndex;

 	if ((input >> minIndex >> maxIndex).fail())
   	throw VectorError(aVector.name(), ERROR_INVALID_IO);

	aVector.resize(minIndex, maxIndex);
   for (int i = minIndex;i <= maxIndex;i++)
   	if ((input >> aVector[i]).fail())
      	throw VectorError(aVector.name(), ERROR_INVALID_IO);
   return input;
 }
// -----> operator <<
//
// SE :
template <class T>
ostream &operator <<(ostream &output, Vector<T> &aVector)
 { output << endl << aVector.minIndex() << " " << aVector.maxIndex() << endl;
 	for (int i = aVector.minIndex();i <= aVector.maxIndex();i++)
      output << aVector[i] << " ";
   output << endl;
 	return output;
 }

#endif
